﻿using System;
using Microsoft.SharePoint;

namespace CreateNewWeb
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            // Hole die Collection der verfügbaren Templates
            SPWebTemplateCollection webTemplates =
               site.GetWebTemplates(1031);

            // Hole das Template des Blogs
            SPWebTemplate blogTemplate = webTemplates["BLOG#0"];

            SPWebCollection allWebs = site.AllWebs;
            SPWeb newWeb = allWebs.Add(
               "Blog",        // URL relativ zum Root Web
               "Mein Blog",   // Titel der Website
               String.Empty,  // Beschreibung
               (uint)1031,    // Sprachnode
               blogTemplate,  // Websitevorlage
               false,         // Vererbung der Berechtigungen
               false);        // Bestehende Seite soll nicht konvertiert werden

            Console.WriteLine("Website erfolgreich stellt: {0}, {1}",
               newWeb.Url, newWeb.Created);
         }
      }
   }
}